<style>
  body {
    background-color: #f8f9fa;
    margin: 0;
    display: flex;
  }

  /* Menú lateral */
  .sidebar {
    background-color: #2563eb;
    color: white;
    padding: 1rem;
    width: 250px;
    height: 100vh;
    position: fixed;
    top: 0;
    left: 0;
    overflow-y: hidden; /* Ocultar barra de scroll */
    transition: all 0.3s ease;
  }

  .sidebar:hover {
    overflow-y: auto; /* Habilitar scroll al pasar el mouse */
  }

  .sidebar h2 {
    font-size: 1.5rem;
    margin-bottom: 1.5rem;
    text-align: center;
  }

  .sidebar a {
    color: white;
    text-decoration: none;
    display: block;
    padding: 0.75rem 1rem;
    font-size: 1.1rem;
    margin-bottom: 1rem;
    border-radius: 5px;
  }

  .sidebar a:hover {
    background-color: #1e3a8a;
  }

  .sidebar .menu-item {
    display: flex;
    align-items: center;
  }

  .sidebar .menu-item i {
    margin-right: 10px;
  }

  .content {
    margin-left: 250px;
    padding: 2rem;
    width: 100%;
  }

  /* Menú móvil */
  .menu-mobile {
    display: none;
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background-color: #2563eb;
    color: white;
    box-shadow: 0 -2px 6px rgba(0, 0, 0, 0.2);
    z-index: 1000;
  }

  .menu-mobile a {
    flex: 1;
    color: white;
    text-decoration: none;
    text-align: center;
    padding: 0.75rem 0;
    font-size: 1rem;
    border-top: 1px solid rgba(255, 255, 255, 0.2);
  }

  .menu-mobile a:hover {
    background-color: #1e3a8a;
  }

  .menu-mobile .menu-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    font-size: 0.8rem;
  }

  /* Responsividad */
  @media (max-width: 768px) {
    .sidebar {
      display: none; /* Ocultar menú lateral */
    }

    .content {
      margin-left: 0;
    }

    .menu-mobile {
      display: flex;
      justify-content: space-around;
    }
  }
</style>

<div class="sidebar">
  <h2>Menú de Administración</h2>
  <a href="dashboard.php" class="menu-item"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
  <a href="generar_ticket.php" class="menu-item"><i class="fas fa-ticket-alt"></i> Tickets</a>
  <a href="usuarios.php" class="menu-item"><i class="fas fa-users"></i> Usuarios</a>
  <a href="clientes.php" class="menu-item"><i class="fas fa-user"></i> Clientes</a>
  <a href="gestion_tipos_tickets.php" class="menu-item"><i class="fas fa-list"></i> Tipo de Tickets</a>
  <a href="configuracion.php" class="menu-item"><i class="fas fa-cogs"></i> Configuración</a>
  <a href="scan_ticket.php" class="menu-item"><i class="fas fa-qrcode"></i> Escanear</a>
  <a href="caja.php" class="menu-item"><i class="fas fa-cash-register"></i> Caja de los usuarios</a>
  <a href="estadisticas.php" class="menu-item"><i class="fas fa-chart-bar"></i> Estadísticas</a>
  <a href="logout.php" class="menu-item"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a>
</div>

<div class="menu-mobile">
  <a href="dashboard.php" class="menu-item"><i class="fas fa-home"></i><span>Inicio</span></a>
  <a href="generar_ticket.php" class="menu-item"><i class="fas fa-ticket-alt"></i><span>Tickets</span></a>
  <a href="scan_ticket.php" class="menu-item"><i class="fas fa-qrcode"></i><span>Escanear</span></a>
  <a href="caja.php" class="menu-item"><i class="fas fa-cash-register"></i><span>Caja</span></a>
  <a href="clientes.php" class="menu-item"><i class="fas fa-user"></i><span>Clientes</span></a>
  <a href="configuracion.php" class="menu-item"><i class="fas fa-cogs"></i><span>Config.</span></a>
</div>

